-- T-SQL Window Functions Deep Dive
-- 4 Analytic Functions
USE AdventureWorks2014;
GO
--LAG AND LEAD
--FRAME not supported!
SELECT CustomerID, SalesOrderID, OrderDate, 
	 LAG(SalesOrderID) OVER( PARTITION BY CustomerID 
		ORDER BY SalesOrderID) AS PreviousOrder,
	 LEAD(SalesOrderID) OVER(PARTITION BY CustomerID 
		ORDER BY SalesOrderID) AS NextOrder
FROM Sales.SalesOrderHeader 
ORDER BY CustomerID,SalesOrderID;

SELECT CustomerID, SalesOrderID, OrderDate,
	DATEDIFF(d,LAG(OrderDate) 
		OVER(PARTITION BY CustomerID ORDER BY SalesOrderID),
	 	OrderDate) AS DaysSinceLast,
    DATEDIFF(d,OrderDate,LEAD(OrderDate) 
		OVER(PARTITION BY CustomerID ORDER BY SalesOrderID))
		AS DaysUntilNext
FROM Sales.SalesOrderHeader 
ORDER BY CustomerID,SalesOrderID;

  

--Optional OFFSET and default parameters
SELECT CustomerID, SalesOrderID, OrderDate, 
	LAG(OrderDate,2,'2001-01-01') 
	OVER(PARTITION BY CustomerID ORDER BY OrderDate) AS Back2Orders 
FROM Sales.SalesOrderHeader; 


--FIRST_VALUE and LAST_VALUE
--FRAME suported -- RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW by default
SELECT CustomerID, OrderDate, TotalDue ,
      FIRST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS FirstTotalDue, 
	  FIRST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS FirstOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;

--Last Value -- weird results!
SELECT CustomerID, OrderDate, TotalDue ,
      LAST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastTotalDue, 
	  LAST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID) AS LastOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;


--What is wrong? 
--The default frame only goes to current row
SELECT CustomerID, OrderDate, TotalDue ,
      LAST_VALUE(TotalDue) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID
	  ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS LastTotalDue, 
	  LAST_VALUE(OrderDate) OVER(PARTITION BY CustomerID 
	  ORDER BY SalesOrderID
	  ROWS BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) AS LastOrderDate 
FROM Sales.SalesOrderHeader
ORDER BY CustomerID, SalesOrderID;



